﻿var timeZonesAreaCodes = {
    context: $(".v-timeZonesAreaCodes"),
    datatable: null,
    treeview: null,
    initializeDataTable: function () {
        this.datatable = $(".h-timeZonesAreCodesTable", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetTimeZonesAndAreaCodes", "MultiMode", "Settings"),
            columns: [
                { "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true },
                { "Title": resources.Code, "Data": "Code", "HideInSelector": true },
                { "Title": resources.Exchange, "Data": "Exchange" },
                { "Title": resources.TimeZone, "Data": "TimeZone" }
            ],
            stateKey: "TimeZonesAreaCodes",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete }
            ],
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "edit", "Label": resources.Edit }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        timeZonesAreaCodes.deleteTimeZones([row.Id]);
                        break;
                    case "edit":
                        modalDialog.showWindow(a4.getAction("EditTimeZoneAreaCode", "MultiMode", "Settings", { id: row.Id }), 450, 700, { afterClose: function () { timeZonesAreaCodes.refreshContent(); } });
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    timeZonesAreaCodes.deleteTimeZones(ids);
                }
            },
            localizableTexts: { "Search": resources.SearchTimeZones }
        });
    },
    bindEvents: function () {
        $(".h-addTimeZoneAreaCode").on("click", function () {
            modalDialog.showWindow(a4.getAction("EditTimeZoneAreaCode", "MultiMode", "Settings", {}), 450, 700, { afterClose: function () { timeZonesAreaCodes.refreshContent(); } });
        });
        $(".h-viewTimeZones").on("click", function () {
            modalDialog.showWindow(a4.getAction("TimeZones", "MultiMode", "Settings", {}), 650, 900, { afterClose: null });
        });
    },
    deleteTimeZones: function (ids) {
        modalDialog.showConfirmDelete(confirmDeleteItemResources, function () {
            a4.callServerMethod(a4.getAction("DeleteTimeZoneAreaCodes", "MultiMode", "Settings"), { ids: ids },
                function (result) {
                    timeZonesAreaCodes.refreshContent();
                });
        }, ids.length);
    },
    refreshContent: function () {
        this.datatable.a4datatable("refresh");
    },
    showBusyBox: function () {
        a4.showBusyBox();
    },
    hideBusyBox: function () {
        a4.hideBusyBox();
    }
}

var timeZones = {
    context: $(".v-timeZones"),
    datatable: null,
    treeview: null,
    initializeDataTable: function () {
        this.datatable = $(".h-timeZones", this.context).a4datatable({
            displayColumnSelector: false,
            ajaxAction: a4.getAction("GetTimeZones", "MultiMode", "Settings"),
            columns: [
                { "Title": a4.parent().resources.Id, "Data": "Id" },
                { "Title": a4.parent().resources.Label, "Data": "Label", },
                { "Title": a4.parent().resources.GMTBias, "Data": "GMTBias", "Type": "numeric" },
                { "Title": a4.parent().resources.DSTActive, "Data": "DSTActive", "Label": "DSTActiveLabel" },
                { "Title": a4.parent().resources.DSTBias, "Data": "DSTBias", "Type": "numeric" }
            ],
            stateKey: "TimeZones"
        });
    }
}

var editTimeZonesAreaCode = {
    context: $(".v-editTimeZoneAreaCode"),
    initialize: function () {
        a4.initializeInputs(editTimeZonesAreaCode.context);
    }
}

$(document).ready(function () {
    if (timeZonesAreaCodes.context.length > 0) {
        timeZonesAreaCodes.initializeDataTable();
        timeZonesAreaCodes.bindEvents();
    }
    else if (timeZones.context.length > 0) {
        timeZones.initializeDataTable();
    }
    else if (editTimeZonesAreaCode.context.length > 0) {
        editTimeZonesAreaCode.initialize();
    }
});